#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/wait.h>

// Function to calculate the sum of numbers from start to end
int calculate_sum(int start, int end) {
    int sum = 0;
    for (int i = start; i <= end; i++) {
        sum += i;
    }
    return sum;
}

int main() {
    int N;
    
    printf("Enter a number (N<=25): ");
    scanf("%d", &N);
    
    // Fork a child process
    pid_t pid = fork();
    
    if (pid == -1) {
        perror("fork");
        exit(EXIT_FAILURE);
    } else if (pid == 0) {
        // Child process 1
        int sum = calculate_sum(1, N / 2);
        printf("Child 1: Sum of numbers from 1 to %d is %d\n", N / 2, sum);
        exit(sum);
    } else {
        // Parent process
        pid_t pid2 = fork(); // Fork another child process
        
        if (pid2 == -1) {
            perror("fork");
            exit(EXIT_FAILURE);
        } else if (pid2 == 0) {
            // Child process 2
            int sum = calculate_sum(N / 2 + 1, N);
            printf("Child 2: Sum of numbers from %d to %d is %d\n", N / 2 + 1, N, sum);
            exit(sum);
        } else {
            // Parent process
            int status1, status2;
            waitpid(pid, &status1, 0); // Wait for child process 1
            waitpid(pid2, &status2, 0); // Wait for child process 2
            
            int total_sum = WEXITSTATUS(status1) + WEXITSTATUS(status2);
            printf("Parent: Total sum of numbers from 1 to %d is %d\n", N, total_sum);
        }
    }
    
    return 0;
}
