#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/wait.h>

int main(void) {
    pid_t pid;

    printf("Before fork(): PID=%d, PPID=%d\n", getpid(), getppid());

    pid = fork();  // create child

    if (pid < 0) {
        perror("fork failed");
        exit(1);
    } else if (pid == 0) {
        // Child process
        printf("Child: PID=%d, PPID=%d, fork returned %d\n",
               getpid(), getppid(), pid);
        /* do some work to show different times */
        for (int i = 0; i < 3; ++i) {
            printf("Child (%d): count %d\n", getpid(), i);
            sleep(1);
        }
        _exit(0); // use _exit to avoid flushing parent's stdio buffers twice
    } else {
        // Parent process
        printf("Parent: PID=%d, child PID=%d\n", getpid(), pid);
        /* wait for child to finish */
        int status;
        waitpid(pid, &status, 0);
        printf("Parent: child %d exited with status %d\n", pid, WEXITSTATUS(status));
    }

    return 0;
}
