#!/bin/bash

echo "---------------------------------------------"
echo " System Information Using /proc File System"
echo "---------------------------------------------"

echo ""
echo " (a) Number of CPU cores:"
cores=$(grep -c ^processor /proc/cpuinfo)
echo "     CPU Cores: $cores"

echo ""
echo " (b) Total memory and fraction of free memory:"
total_mem=$(grep MemTotal /proc/meminfo | awk '{print $2}')
free_mem=$(grep MemFree /proc/meminfo | awk '{print $2}')
available=$(grep MemAvailable /proc/meminfo | awk '{print $2}')

echo "     Total Memory     : $total_mem kB"
echo "     Free Memory      : $free_mem kB"
echo "     Available Memory : $available kB"
fraction=$(echo "scale=2; $free_mem/$total_mem" | bc)
echo "     Fraction Free    : $fraction"

echo ""
echo " (c) Number of processes currently running:"
running=$(ps -e --no-headers | wc -l)
echo "     Total Processes: $running"

echo ""
echo " (d) Number of processes in Running and Blocked states:"
running_state=$(ps -eo stat | grep -c "^R")
blocked_state=$(ps -eo stat | grep -c "^D")
echo "     Running Processes : $running_state"
echo "     Blocked (Uninterruptible Sleep) Processes: $blocked_state"

echo ""
echo " (e) Number of processes forked since last boot:"
forks=$(grep processes /proc/stat | awk '{print $2}')
echo "     Processes Forked Since Boot: $forks"


echo ""
echo " (f) Number of context switches for a particular process:"
echo -n "     Enter PID: "
read pid

if [ -d "/proc/$pid" ]; then
    ctxt=$(grep ctxt /proc/$pid/status)
    echo "     $ctxt"
else
    echo "     Invalid PID — process does not exist."
fi

echo ""
echo "---------------------------------------------"
echo " Script Completed."
echo "---------------------------------------------"
